package com.qboxus.tictic.koin

import android.content.Context
import android.content.SharedPreferences
import com.qboxus.tictic.repositories.AddressRepository
import com.qboxus.tictic.repositories.ChatRepository
import com.qboxus.tictic.repositories.NotificationRepository
import com.qboxus.tictic.repositories.ReportRepository
import com.qboxus.tictic.repositories.RoomRepository
import com.qboxus.tictic.repositories.ShopRepository
import com.qboxus.tictic.repositories.SplashRepository
import com.qboxus.tictic.repositories.StripeRepository
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.viewModels.AddPayoutViewModel
import com.qboxus.tictic.viewModels.AddressViewModel
import com.qboxus.tictic.viewModels.BlockUsersViewModel
import com.qboxus.tictic.viewModels.DeleteAccountViewModel
import com.qboxus.tictic.viewModels.DiscoverViewModel
import com.qboxus.tictic.viewModels.EditProfileViewModel
import com.qboxus.tictic.viewModels.FavouriteVideosViewModel
import com.qboxus.tictic.viewModels.FollowersViewModel
import com.qboxus.tictic.viewModels.HomeViewModel
import com.qboxus.tictic.viewModels.InboxViewModel
import com.qboxus.tictic.viewModels.LikedVideosViewModel
import com.qboxus.tictic.viewModels.MainMenuViewModel
import com.qboxus.tictic.viewModels.MainSearchViewModel
import com.qboxus.tictic.viewModels.MyProfileViewModel
import com.qboxus.tictic.viewModels.NearByVideoViewModel
import com.qboxus.tictic.viewModels.NotificationViewModel
import com.qboxus.tictic.viewModels.OthersProfileViewModel
import com.qboxus.tictic.viewModels.PrivacyPolicyViewModel
import com.qboxus.tictic.viewModels.PrivateVideosViewModel
import com.qboxus.tictic.viewModels.ProfileVerificationViewModel
import com.qboxus.tictic.viewModels.ProfileViewsViewModel
import com.qboxus.tictic.viewModels.PushNotificationViewModel
import com.qboxus.tictic.viewModels.ReportViewModel
import com.qboxus.tictic.viewModels.RepostVideosViewModel
import com.qboxus.tictic.viewModels.SearchAllUsersViewModel
import com.qboxus.tictic.viewModels.ShowPayoutViewModel
import com.qboxus.tictic.viewModels.SplashViewModel
import com.qboxus.tictic.viewModels.StripeViewModel
import com.qboxus.tictic.viewModels.TaggedVideoViewModel
import com.qboxus.tictic.viewModels.UserVideosViewModel
import com.qboxus.tictic.viewModels.VideoActionsViewModel
import com.qboxus.tictic.viewModels.VideoPlayViewModel
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module

val appModule= module {

    single<SharedPreferences> {
        Functions.getSharedPreference(get<Context>())
    }

    single { AddressRepository() }
    single { NotificationRepository() }
    single { ReportRepository() }
    single { ShopRepository() }
    single { RoomRepository() }
    single { StripeRepository() }
    single { UserRepository() }
    single { VideosRepository() }
    single { WalletRepository() }
    single { ChatRepository() }
    single { SplashRepository() }

    // Provide ViewModels (Each separately)

    viewModel { InboxViewModel(get<Context>()) }

    viewModel { MainMenuViewModel(get<SharedPreferences>(), get<AddressRepository>(), get<UserRepository>()) }
    viewModel { AddPayoutViewModel(get<Context>(), get<WalletRepository>()) }
    viewModel { AddressViewModel(get<Context>(), get<AddressRepository>()) }

    viewModel { BlockUsersViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { DeleteAccountViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { EditProfileViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { FollowersViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { PrivacyPolicyViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { ProfileVerificationViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { PushNotificationViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { SearchAllUsersViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { ProfileViewsViewModel(get<Context>(), get<UserRepository>()) }
    viewModel { OthersProfileViewModel(get<Context>(), get<UserRepository>()) }





    viewModel { NotificationViewModel(get(), get(),get()) }
    viewModel { HomeViewModel(get(), get(),get(),get()) }
    viewModel { DiscoverViewModel(get(), get(),get(),get()) }

    viewModel { MyProfileViewModel(get<Context>(), get<UserRepository>(),get<ChatRepository>()) }

    viewModel { UserVideosViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { TaggedVideoViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { LikedVideosViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { NearByVideoViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { RepostVideosViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { PrivateVideosViewModel(get<Context>(), get<VideosRepository>()) }
    viewModel { FavouriteVideosViewModel(get<Context>(), get<VideosRepository>()) }



    viewModel { VideoPlayViewModel(get<Context>(), get<UserRepository>(),get<VideosRepository>()) }
    viewModel { VideoActionsViewModel(get<Context>(), get<UserRepository>(),get<VideosRepository>()) }
    viewModel { MainSearchViewModel(get<Context>(), get<UserRepository>(),get<VideosRepository>()) }

    viewModel { SplashViewModel(get<Context>(), get<SplashRepository>(),get<AddressRepository>(),get<VideosRepository>()) }


    viewModel{ ReportViewModel(get<Context>(), get<ReportRepository>()) }

    viewModel{ ShowPayoutViewModel(get<Context>(), get<WalletRepository>()) }

    viewModel{ StripeViewModel(get<Context>(),get<StripeRepository>(), get<WalletRepository>()) }



}